/*
 *  linux/arch/arm/mach-uniphier/include/mach/lpu-regs.h
 *
 *  Copyright (C) 2012 Panasonic Corporation
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 */

#ifndef _ASM_ARCH_LPU_H
#define _ASM_ARCH_LPU_H

#define LPU_BASE	(0x5b800000)	/* P.A. */


#define LPU_CA_BASE(a)	(LPU_BASE + 0x1000 + 0x1000 * ((a) % 2) + 0x4000 * ((a) / 2))
#define LPU_DC_BASE(a)	(LPU_BASE + 0x400000 + 0x200000 * ((a) % 2) + 0x2000000 * ((a) / 2))

#ifdef CONFIG_MACH_MN2WS0220_REF
#define LPU_MOPTION_A(a) (LPU_CA_BASE(a) + 0x200)
#define LPU_MOPTION_B(a) (LPU_CA_BASE(a) + 0x204)
#define LPU_MOPTION_C(a) (LPU_CA_BASE(a) + 0x208)
#define LPU_MOPTION_D(a) (LPU_CA_BASE(a) + 0x20c)
#define LPU_MOPTION_E(a) (LPU_CA_BASE(a) + 0x210)
#define LPU_MOPTION_F(a) (LPU_CA_BASE(a) + 0x214)
#define LPU_MOPTION_G(a) (LPU_CA_BASE(a) + 0x218)
#define LPU_MOPTION_H(a) (LPU_CA_BASE(a) + 0x21c)
#define LPU_MOPTION_I(a) (LPU_CA_BASE(a) + 0x220)
#define LPU_MOPTION_J(a) (LPU_CA_BASE(a) + 0x224)
#define LPU_MOPTION_L(a) (LPU_CA_BASE(a) + 0x228)
#define LPU_MOPTION_M(a) (LPU_CA_BASE(a) + 0x22c)
#define LPU_MOPTION_O(a) (LPU_CA_BASE(a) + 0x230)
#define LPU_MOPTION_P(a) (LPU_CA_BASE(a) + 0x234)
#define LPU_MOPTION_Q(a) (LPU_CA_BASE(a) + 0x238)
#define LPU_MOPTION_R(a) (LPU_CA_BASE(a) + 0x23c)
#define LPU_MOPTION_S(a) (LPU_CA_BASE(a) + 0x240)
#define LPU_MOPTION_T(a) (LPU_CA_BASE(a) + 0x244)
#define LPU_MOPTION_U(a) (LPU_CA_BASE(a) + 0x248)
#define LPU_MOPTION_V(a) (LPU_CA_BASE(a) + 0x24c)
#define LPU_MOPTION_W(a) (LPU_CA_BASE(a) + 0x250)

#define LPUSCTLB(a)	    (LPU_DC_BASE(a) + 0x0034)
#define LPUSSETC(a)	    (LPU_DC_BASE(a) + 0x0040)

#define LPUACTLD(a)		(LPU_DC_BASE(a) + 0x034c)
#define LPUACTLE(a)		(LPU_DC_BASE(a) + 0x0350)

#define LPUCENDC(a)		(LPU_DC_BASE(a) + 0x8000)


#elif defined (CONFIG_MACH_MN2WS0251_REF) || defined(CONFIG_MACH_MN2WS0270_REF)
#define LPU_MOPTION_A(ch)	(LPU_CA_BASE(ch) + 0x200)
#define LPU_MOPTION_B(ch)	(LPU_CA_BASE(ch) + 0x204)
#define LPU_MOPTION_C(ch)	(LPU_CA_BASE(ch) + 0x208)
#define LPU_MOPTION_D(ch)	(LPU_CA_BASE(ch) + 0x20C)
#define LPU_MOPTION_E(ch)	(LPU_CA_BASE(ch) + 0x210)
#define LPU_MOPTION_F(ch)	(LPU_CA_BASE(ch) + 0x214)
#define LPU_MOPTION_G(ch)	(LPU_CA_BASE(ch) + 0x218)
#define LPU_MOPTION_H(ch)	(LPU_CA_BASE(ch) + 0x21C)
#define LPU_MOPTION_I(ch)	(LPU_CA_BASE(ch) + 0x220)
#define LPU_MOPTION_J(ch)	(LPU_CA_BASE(ch) + 0x224)
#define LPU_MOPTION_K(ch)	(LPU_CA_BASE(ch) + 0x228)
#define LPU_MOPTION_L(ch)	(LPU_CA_BASE(ch) + 0x22C)
#define LPU_MOPTION_M(ch)	(LPU_CA_BASE(ch) + 0x230)
#define LPU_MOPTION_N(ch)	(LPU_CA_BASE(ch) + 0x234)


#define LPUSSETB(a)			(LPU_DC_BASE(a) + 0x003c)
#define LPUSSTAC(a)			(LPU_DC_BASE(a) + 0x0058)

#define LPULPCTLA(a)		(LPU_DC_BASE(a) + 0x00000C40)
#endif

#endif  /* _ASM_ARCH_LPU_H */
